unit SharedPersistenceMapperEcoSpace;

interface

uses
  System.Threading,
  Borland.Eco.Services,
  Borland.Eco.UmlCodeAttributes,
  Borland.Eco.Handles,
  CoreClassesUnit, Borland.Eco.Persistence;

type
  [EcoSpace]
  [EcoSpacePackage(TypeOf(CoreClassesUnit.CoreClasses))]

  TSharedPersistenceMapperEcoSpace = class(Borland.Eco.Handles.DefaultEcoSpace)
  strict private
    PersistenceMapperSharer1: Borland.Eco.Persistence.PersistenceMapperSharer;
    procedure InitializeComponent;
    class var fTypeSystemProvider: ITypeSystemService;
    class var fTypeSystemProviderLock: Tobject;
  strict protected
    function GetTypeSystemProvider: ITypeSystemService; override;
  public
    constructor Create;
    class constructor Create;
    class function GetTypeSystemService: ITypeSystemService; static;
    procedure UpdateDatabase;
    function get_PersistenceService: IPersistenceService;
    property PersistenceService: IPersistenceService read get_PersistenceService;
    function get_DirtyListService: IDirtyListService;
    property DirtyListService: IDirtyListService read get_DirtyListService;
    function get_UndoService: IUndoService;
    property UndoService: IUndoService read get_UndoService;
    function get_TypeSystemService: ITypeSystemService;
    property TypeSystemService: ITypeSystemService read get_TypeSystemService;
    function get_OclService: IOclService;
    property OclService: IOclService read get_OclService;
    function get_ObjectFactoryService: IObjectFactoryService;
    property ObjectFactoryService: IObjectFactoryService read get_ObjectFactoryService;
    function get_VariableFactoryService: IVariableFactoryService;
    property VariableFactoryService: IVariableFactoryService read get_VariableFactoryService;
  end;

implementation

uses
  EcoPersistenceMapperProvider;
{$AUTOBOX ON}

constructor TSharedPersistenceMapperEcoSpace.Create;
begin
  inherited Create;
  InitializeComponent;
  // TODO: Add any constructor code here
end;

class constructor TSharedPersistenceMapperEcoSpace.Create;
begin
  fTypeSystemProviderLock := TObject.Create;
end;

class function TSharedPersistenceMapperEcoSpace.GetTypeSystemService: ITypeSystemService;
begin
  if not Assigned(fTypeSystemProvider) then
  begin
    try
      Monitor.Enter(fTypeSystemProviderLock);
      if not Assigned(fTypeSystemProvider) then
        fTypeSystemProvider := MakeTypeService(typeOf(TSharedPersistenceMapperEcoSpace));
    finally
      Monitor.Exit(fTypeSystemProviderLock);
    end;
  end;
  Result := fTypeSystemProvider;
end;

function TSharedPersistenceMapperEcoSpace.GetTypeSystemProvider: ITypeSystemService;
begin
  Result := TSharedPersistenceMapperEcoSpace.GetTypeSystemService;
end;

procedure TSharedPersistenceMapperEcoSpace.UpdateDatabase;
begin
  if Assigned(PersistenceService) and Assigned(DirtyListService) then
    PersistenceService.UpdateDatabaseWithList(DirtyListService.AllDirtyObjects);
end;

function TSharedPersistenceMapperEcoSpace.get_PersistenceService: IPersistenceService;
begin
  Result := GetEcoService(typeof(IPersistenceService)) as IPersistenceService;
end;

function TSharedPersistenceMapperEcoSpace.get_DirtyListService: IDirtyListService;
begin
  Result := GetEcoService(typeof(IDirtyListService)) as IDirtyListService;
end;

function TSharedPersistenceMapperEcoSpace.get_UndoService: IUndoService;
begin
  Result := GetEcoService(typeof(IUndoService)) as IUndoService;
end;

function TSharedPersistenceMapperEcoSpace.get_TypeSystemService: ITypeSystemService;
begin
  Result := GetEcoService(typeof(ITypeSystemService)) as ITypeSystemService;
end;

function TSharedPersistenceMapperEcoSpace.get_OclService: IOclService;
begin
  Result := GetEcoService(typeof(IOclService)) as IOclService;
end;

function TSharedPersistenceMapperEcoSpace.get_ObjectFactoryService: IObjectFactoryService;
begin
  Result := GetEcoService(typeof(IObjectFactoryService)) as IObjectFactoryService;
end;

function TSharedPersistenceMapperEcoSpace.get_VariableFactoryService: IVariableFactoryService;
begin
  Result := GetEcoService(typeof(IVariableFactoryService)) as IVariableFactoryService;
end;

procedure TSharedPersistenceMapperEcoSpace.InitializeComponent;
begin
  Self.PersistenceMapperSharer1 := Borland.Eco.Persistence.PersistenceMapperSharer.Create;
  // 
  // PersistenceMapperSharer1
  // 
  Self.PersistenceMapperSharer1.MapperProviderType := TypeOf(EcoPersistenceMapperProvider.TEcoPersistenceMapperProvider);
  // 
  // TSharedPersistenceMapperEcoSpace
  // 
  Self.PersistenceMapper := Self.PersistenceMapperSharer1;
end;

end.
